export async function logAudit(
  username,
  action_type,
  table_name,
  record_id,
  field_name = null,
  old_value = null,
  new_value = null,
  details = null
) {
    const timestamp = new Date().toISOString();

    const query = `
        INSERT INTO audit_logs 
        (timestamp, username, action_type, table_name, record_id, field_name, old_value, new_value, details)
        VALUES ($1, $2, $3, $4, $5, $6, $7, $8, $9)
    `;

    const values = [
        timestamp,
        username,
        action_type,
        table_name,
        record_id,
        field_name,
        old_value,
        new_value,
        details
    ];

    try {
        await pool.query(query, values);
        console.log(`Audit logged: ${action_type} on ${table_name} (ID: ${record_id}) by ${username}`);
    } catch (err) {
        console.error('Error logging audit:', err.message);
    }
}
